#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=198279 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (173999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-06 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174326, 'Database Backup [database_backup_2025-01-07-00-05-02-v3-1-6.zip]', '2025-01-07 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (174999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175014, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-07 21:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175015, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-07 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-07 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-07 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-07 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175121, 'Database Backup [database_backup_2025-01-08-00-04-02-v3-1-6.zip]', '2025-01-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175812, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Due Notice]', '2025-01-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-08 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-08 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-08 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175909, 'Database Backup [database_backup_2025-01-09-00-00-05-v3-1-6.zip]', '2025-01-09 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (175999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 09:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-09 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176717, 'Database Backup [database_backup_2025-01-10-00-00-03-v3-1-6.zip]', '2025-01-10 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (176999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177387, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-01-10 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177388, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-10 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177488, 'Database Backup [database_backup_2025-01-11-00-00-03-v3-1-6.zip]', '2025-01-11 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (177999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-01-11 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-01-11 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (178107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-01-11 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, 