#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=372080 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354026, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8c5:89df:d52a:f69f:965a]', '2025-08-29 19:30:14', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354027, 'Cron Invoked Manually', '2025-08-29 19:31:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354028, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354029, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354030, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354031, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:15', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354032, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354033, 'Invoice Status Updated [Invoice Number: INV-185/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354034, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-08-29 19:32:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354035, 'Invoice Status Updated [Invoice Number: INV-186/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354036, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354037, 'Invoice Status Updated [Invoice Number: INV-187/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354038, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354039, 'Invoice Status Updated [Invoice Number: INV-188/08/2025, From: Unpaid To: Overdue]', '2025-08-29 19:32:29', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354040, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354044, 'Database Backup [database_backup_2025-08-29-19-32-33-v3-3-1.zip]', '2025-08-29 19:32:33', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354045, 'Invoice Status Updated [Invoice Number: INV-178/07/2025, From: Overdue To: Paid]', '2025-08-29 19:36:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354046, 'Payment Recorded [ID:137, Invoice Number: INV-178/07/2025, Total: $500.00]', '2025-08-29 19:36:13', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354047, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-08-29 19:36:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-29 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 16:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 16:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 16:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:12:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-30 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354933, 'Database Backup [database_backup_2025-08-31-00-00-04-v3-3-1.zip]', '2025-08-31 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:03:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:41:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:41:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:41:35', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (354999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:23:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:23:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:23:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355687, 'Database Backup [database_backup_2025-09-01-00-04-04-v3-3-1.zip]', '2025-09-01 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (355999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356345, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356346, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356347, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356348, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356349, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-01 21:02:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356350, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356351, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356352, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-01 21:02:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:02:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:02:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:02:39', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-01 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356449, 'Database Backup [database_backup_2025-09-02-00-02-04-v3-3-1.zip]', '2025-09-02 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 07:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (356999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-02 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-02 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-02 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357200, 'Database Backup [database_backup_2025-09-03-00-02-02-v3-3-1.zip]', '2025-09-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 11:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:24:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 15:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 21:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-03 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-03 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-03 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357954, 'Database Backup [database_backup_2025-09-04-00-04-03-v3-3-1.zip]', '2025-09-04 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 00:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (357999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 04:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 09:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 10:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-04 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-04 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-04 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (358467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-0