#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=61324 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 04:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 04:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 04:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 06:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 06:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 06:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 07:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 07:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 07:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 08:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 08:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 08:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 10:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 11:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 11:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 11:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 11:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 11:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 11:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 12:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 12:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 12:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 13:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 13:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 13:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 14:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39249, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 15:15:19', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39250, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: New Project Discussion (Sent to Project Members)]', '2024-07-18 15:15:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39251, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: New Project Discussion (Sent to Customer Contacts)]', '2024-07-18 15:15:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39252, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: New Project Discussion (Sent to Customer Contacts)]', '2024-07-18 15:15:52', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39256, 'Project Updated [ID: 47]', '2024-07-18 15:29:32', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39257, 'Project Updated [ID: 25]', '2024-07-18 15:31:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39258, 'Project Updated [ID: 43]', '2024-07-18 15:31:57', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39259, 'Project Updated [ID: 47]', '2024-07-18 15:32:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39260, 'Project Updated [ID: 22]', '2024-07-18 15:32:42', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39261, 'Project Updated [ID: 23]', '2024-07-18 15:32:55', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39262, 'Project Updated [ID: 26]', '2024-07-18 15:33:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39263, 'Project Updated [ID: 27]', '2024-07-18 15:33:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39264, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 15:35:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39265, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 15:35:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39266, 'Knowledge Base Group Deleted', '2024-07-18 15:39:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39267, 'Knowledge Base Group Deleted', '2024-07-18 15:39:30', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39268, 'New Article Group Added [GroupID: 3]', '2024-07-18 15:39:54', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39269, 'New Article Added [ArticleID: 1 GroupID: 3]', '2024-07-18 15:41:42', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39273, 'Non Existing User Tried to Login [Email: bdallasferdinand@outlook.com, Is Staff Member: No, IP: 200.7.90.184]', '2024-07-18 15:45:57', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39274, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 15:59:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 16:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 16:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 16:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39278, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 16:01:33', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39279, 'Client Deleted [ID: 77]', '2024-07-18 16:16:51', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39283, 'Invoice Status Updated [Invoice Number: INV-117/03/2024, From: Overdue To: Paid]', '2024-07-18 16:35:11', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39284, 'Payment Recorded [ID:101, Invoice Number: INV-117/03/2024, Total: $350.00]', '2024-07-18 16:35:11', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 17:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 17:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 17:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 17:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 17:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 17:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 18:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 18:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 18:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 19:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 19:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 19:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 19:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 20:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 20:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 20:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39318, 'Project Updated [ID: 26]', '2024-07-18 20:17:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39319, 'Project Updated [ID: 26]', '2024-07-18 20:18:19', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39320, 'Project Updated [ID: 26]', '2024-07-18 20:18:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39321, 'Email Sent To [Email: livinglovelly@gmail.com, Template: New Project Created (Sent to Customer Contacts)]', '2024-07-18 20:19:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39322, 'Project Updated [ID: 47]', '2024-07-18 20:19:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39326, 'Project Updated [ID: 24]', '2024-07-18 20:32:06', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39327, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:36:30', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39328, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:36:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39329, 'New Task Added [ID:219, Name: First draft]', '2024-07-18 20:36:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39330, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:37:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39331, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:37:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39332, 'New Task Added [ID:220, Name: Draft 2]', '2024-07-18 20:37:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39333, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:39:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39334, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:39:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39335, 'New Task Added [ID:221, Name: Third Website Draft]', '2024-07-18 20:39:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39336, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 20:39:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39337, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 20:39:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39338, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 20:39:41', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39339, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 20:39:41', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39340, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:41:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39341, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:41:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39342, 'New Task Added [ID:222, Name: Reviews Adjustment]', '2024-07-18 20:41:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39346, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:43:32', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39347, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:43:32', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39348, 'New Task Added [ID:223, Name: Website completed]', '2024-07-18 20:43:32', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39349, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 20:43:47', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39350, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 20:43:47', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39351, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 20:43:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39352, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 20:43:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39353, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:44:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39354, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:44:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39355, 'New Task Added [ID:224, Name: App Development]', '2024-07-18 20:44:52', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39356, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 20:45:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39357, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 20:45:37', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39358, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 20:46:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39359, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 20:46:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39360, 'New Task Added [ID:225, Name: Branding]', '2024-07-18 20:46:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39361, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 20:46:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39362, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 20:46:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39363, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 20:49:44', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39364, 'User Successfully Logged In [User Id: 91, Is Staff Member: No, IP: 200.7.90.184]', '2024-07-18 20:50:17', 'Esther Primus');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39365, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-18 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39366, 'Email Sent To [Email: nobadistributionbv@gmail.com, Template: Invoice Overdue Notice]', '2024-07-18 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 21:00:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39370, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 21:08:18', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39371, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 21:10:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39372, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 21:10:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39373, 'New Task Added [ID:226, Name: First Draft]', '2024-07-18 21:10:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39374, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 21:11:16', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39375, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 21:11:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39376, 'New Task Added [ID:227, Name: Second Draft]', '2024-07-18 21:11:17', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39377, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 21:13:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39378, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 21:13:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39379, 'New Task Added [ID:228, Name: Third Draft]', '2024-07-18 21:13:25', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39380, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 21:14:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39381, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 21:14:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39382, 'New Task Added [ID:229, Name: Final Draft]', '2024-07-18 21:14:53', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39383, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 21:16:38', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39384, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 21:16:39', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39385, 'New Task Added [ID:230, Name: Hand over]', '2024-07-18 21:16:39', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39386, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Task Assigned (Sent to Staff)]', '2024-07-18 21:17:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39387, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Staff Member Added as Follower on Task (Sent to Staff)]', '2024-07-18 21:17:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39388, 'New Task Added [ID:231, Name: Project Complete!]', '2024-07-18 21:17:27', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39389, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 21:17:51', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39390, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 21:17:51', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39391, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 21:17:54', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39392, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 21:17:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39393, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 21:17:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39394, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 21:17:58', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39395, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 21:18:00', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39396, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 21:18:00', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39397, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Task Status Changed (Sent to Staff)]', '2024-07-18 21:18:03', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39398, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Task Status Changed (Sent to Customer Contacts)]', '2024-07-18 21:18:03', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39399, 'Non Existing User Tried to Login [Email: Info@lobaxtt.com, Is Staff Member: No, IP: 200.7.90.184]', '2024-07-18 21:20:05', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39403, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 200.7.90.184]', '2024-07-18 21:21:26', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39407, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 21:52:55', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39408, 'Estimate Request Deleted [Deleted by: Tishara Ferdinand, ID: 29]', '2024-07-18 21:54:32', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39409, 'Estimate Request Deleted [Deleted by: Tishara Ferdinand, ID: 28]', '2024-07-18 21:55:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39410, 'Estimate Request Deleted [Deleted by: Tishara Ferdinand, ID: 27]', '2024-07-18 21:55:07', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39411, 'Customer Info Updated [ID: 21]', '2024-07-18 21:59:39', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 22:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 22:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 22:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39415, 'Project Updated [ID: 40]', '2024-07-18 22:00:14', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39416, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.184]', '2024-07-18 22:14:57', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 23:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 23:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 23:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-18 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-18 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-18 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39435, 'Database Backup [database_backup_2024-07-19-00-00-09-v3-1-1.zip]', '2024-07-19 00:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 00:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 01:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 02:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 02:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 02:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 02:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 02:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 02:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 03:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 03:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 03:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 04:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 04:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 04:00:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39484, 'Email Sent To [Email: yourdietcormeer@gmail.com, Template: Email Verification (Sent to Contact After Registration)]', '2024-07-19 05:26:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39485, 'Contact Created [ID: 111]', '2024-07-19 05:26:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39486, 'New Client Created [ID: 102]', '2024-07-19 05:26:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39487, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: New Customer Registration (Sent to admins)]', '2024-07-19 05:26:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39488, 'Email Sent To [Email: clientportal@saylesstt.com, Template: New Customer Registration (Sent to admins)]', '2024-07-19 05:26:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39489, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: New Customer Registration (Sent to admins)]', '2024-07-19 05:26:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39490, 'Non Existing User Tried to Login [Email: yourdietcotneer@gmail.com, Is Staff Member: No, IP: 181.118.42.109]', '2024-07-19 05:27:43', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39491, 'Non Existing User Tried to Login [Email: yourdietcorneer@gmail.com, Is Staff Member: No, IP: 181.118.42.109]', '2024-07-19 05:28:15', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39492, 'Non Existing User Tried to Login [Email: yourdietcorneer@gmail.com, Is Staff Member: No, IP: 181.118.42.109]', '2024-07-19 05:29:52', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39493, 'Failed Login Attempt [Email: livinglovelly@gmail.com, Is Staff Member: No, IP: 181.118.42.109]', '2024-07-19 05:30:20', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 06:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 06:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 06:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 07:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 07:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 07:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 08:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 08:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 08:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39527, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.182]', '2024-07-19 09:05:59', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39528, 'Invoice Status Updated [Invoice Number: INV-152/07/2024, From: Overdue To: Paid]', '2024-07-19 09:07:56', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39529, 'Payment Recorded [ID:102, Invoice Number: INV-152/07/2024, Total: $3,250.00]', '2024-07-19 09:07:56', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39530, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-19 09:08:04', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39531, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-19 09:08:07', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 10:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 10:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 10:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 11:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 11:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 11:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 12:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 12:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 12:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39562, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.182]', '2024-07-19 12:21:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 13:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 14:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 14:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 14:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39578, 'Payment Recorded [ID:103, Invoice Number: INV-134/05/2024, Total: $2,500.00]', '2024-07-19 14:20:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39579, 'Email Sent To [Email: drelectronicstt@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-19 14:20:24', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 15:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 16:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 16:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 16:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 17:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 17:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:13:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:13:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:13:30', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39619, 'Email sent to: randellboodram3@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39620, 'Newsletter Sent [To : randellboodram3@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39621, 'Email sent to: musicteck@live.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39622, 'Newsletter Sent [To : musicteck@live.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39623, 'Email sent to: kendellseebaran12@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39624, 'Newsletter Sent [To : kendellseebaran12@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39625, 'Email sent to: sianramdass.1924@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39626, 'Newsletter Sent [To : sianramdass.1924@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39627, 'Email sent to: meandgodnj5256944@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39628, 'Newsletter Sent [To : meandgodnj5256944@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39629, 'Email sent to: sfveon1@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39630, 'Newsletter Sent [To : sfveon1@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39631, 'Email sent to: pmohan121985@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39632, 'Newsletter Sent [To : pmohan121985@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39633, 'Email sent to: royaltysalesandcourierservices@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39634, 'Newsletter Sent [To : royaltysalesandcourierservices@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39635, 'Email sent to: tjbenjamin18@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39636, 'Newsletter Sent [To : tjbenjamin18@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39637, 'Email sent to: zionlioniron@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39638, 'Newsletter Sent [To : zionlioniron@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39639, 'Email sent to: rramkissoon@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39640, 'Newsletter Sent [To : rramkissoon@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39641, 'Email sent to: kedashay41@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39642, 'Newsletter Sent [To : kedashay41@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39643, 'Email sent to: divaforever0412@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39644, 'Newsletter Sent [To : divaforever0412@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39645, 'Email sent to: roxannep1977@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39646, 'Newsletter Sent [To : roxannep1977@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39647, 'Email sent to: cggomdon@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39648, 'Newsletter Sent [To : cggomdon@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39649, 'Email sent to: marlongarie@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39650, 'Newsletter Sent [To : marlongarie@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39651, 'Email sent to: ernestosingh2@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39652, 'Newsletter Sent [To : ernestosingh2@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39653, 'Email sent to: spaancharl8@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39654, 'Newsletter Sent [To : spaancharl8@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39655, 'Email sent to: ecestrinidad@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39656, 'Newsletter Sent [To : ecestrinidad@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39657, 'Email sent to: giftedhandshealthcare91@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39658, 'Newsletter Sent [To : giftedhandshealthcare91@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39659, 'Email sent to: candacemcknight@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39660, 'Newsletter Sent [To : candacemcknight@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39661, 'Email sent to: danrodney10@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39662, 'Newsletter Sent [To : danrodney10@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39663, 'Email sent to: errol_mclean@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39664, 'Newsletter Sent [To : errol_mclean@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39665, 'Email sent to: hernandezoranda56@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39666, 'Newsletter Sent [To : hernandezoranda56@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39667, 'Email sent to: andrewmaraj5762@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39668, 'Newsletter Sent [To : andrewmaraj5762@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39669, 'Email sent to: starsign84@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39670, 'Newsletter Sent [To : starsign84@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39671, 'Email sent to: cherlan.jaglal@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39672, 'Newsletter Sent [To : cherlan.jaglal@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39673, 'Email sent to: maninemn85@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39674, 'Newsletter Sent [To : maninemn85@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39675, 'Email sent to: kerrylamothe@icould.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39676, 'Newsletter Sent [To : kerrylamothe@icould.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39677, 'Email sent to: marietegalara@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39678, 'Newsletter Sent [To : marietegalara@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39679, 'Email sent to: getkgb@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39680, 'Newsletter Sent [To : getkgb@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39681, 'Email sent to: kevykevkev23@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39682, 'Newsletter Sent [To : kevykevkev23@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39683, 'Email sent to: robertthompson@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39684, 'Newsletter Sent [To : robertthompson@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39685, 'Email sent to: naresh.sookhan@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39686, 'Newsletter Sent [To : naresh.sookhan@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39687, 'Email sent to: projenbeauty@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39688, 'Newsletter Sent [To : projenbeauty@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39689, 'Email sent to: limitlessf.tt@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39690, 'Newsletter Sent [To : limitlessf.tt@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39691, 'Email sent to: acvelectrical@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39692, 'Newsletter Sent [To : acvelectrical@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39693, 'Email sent to: simonewillie8@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39694, 'Newsletter Sent [To : simonewillie8@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39695, 'Email sent to: drelectronicstt@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39696, 'Newsletter Sent [To : drelectronicstt@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39697, 'Email sent to: dk.kerr1218@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39698, 'Newsletter Sent [To : dk.kerr1218@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39699, 'Email sent to: kelly.coops1980@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39700, 'Newsletter Sent [To : kelly.coops1980@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39701, 'Email sent to: rondmz64@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39702, 'Newsletter Sent [To : rondmz64@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39703, 'Email sent to: extreme_effect_graphix@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39704, 'Newsletter Sent [To : extreme_effect_graphix@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39705, 'Email sent to: alexisbgomef@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39706, 'Newsletter Sent [To : alexisbgomef@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39707, 'Email sent to: ahsbizconnect@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39708, 'Newsletter Sent [To : ahsbizconnect@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39709, 'Email sent to: seanmotilal753@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39710, 'Newsletter Sent [To : seanmotilal753@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39711, 'Email sent to: jameelglasgow927@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39712, 'Newsletter Sent [To : jameelglasgow927@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39713, 'Email sent to: colinghourlal@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39714, 'Newsletter Sent [To : colinghourlal@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39715, 'Email sent to: twobyouthealth56@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39716, 'Newsletter Sent [To : twobyouthealth56@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39717, 'Email sent to: aguilleraazim@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39718, 'Newsletter Sent [To : aguilleraazim@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39719, 'Email sent to: afromeal1@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39720, 'Newsletter Sent [To : afromeal1@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39721, 'Email sent to: msl2170@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39722, 'Newsletter Sent [To : msl2170@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39723, 'Email sent to: jquamina89@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39724, 'Newsletter Sent [To : jquamina89@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39725, 'Email sent to: ayanacwilliams101@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39726, 'Newsletter Sent [To : ayanacwilliams101@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39727, 'Email sent to: jinjinhair19@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39728, 'Newsletter Sent [To : jinjinhair19@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39729, 'Email sent to: leelovelocs05@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39730, 'Newsletter Sent [To : leelovelocs05@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39731, 'Email sent to: adrian@fancyfixturesltd.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39732, 'Newsletter Sent [To : adrian@fancyfixturesltd.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39733, 'Email sent to: mangaleebobby@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39734, 'Newsletter Sent [To : mangaleebobby@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39735, 'Email sent to: adeolakobie@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39736, 'Newsletter Sent [To : adeolakobie@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39737, 'Email sent to: clevonwilliamsonsex@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39738, 'Newsletter Sent [To : clevonwilliamsonsex@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39739, 'Email sent to: warnerayanna78@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39740, 'Newsletter Sent [To : warnerayanna78@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39741, 'Email sent to: dinstaller@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39742, 'Newsletter Sent [To : dinstaller@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39743, 'Email sent to: keonporter000@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39744, 'Newsletter Sent [To : keonporter000@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39745, 'Email sent to: omarimoore19@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39746, 'Newsletter Sent [To : omarimoore19@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39747, 'Email sent to: keripatrick@me.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39748, 'Newsletter Sent [To : keripatrick@me.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39749, 'Email sent to: marc@apangsmarketing.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39750, 'Newsletter Sent [To : marc@apangsmarketing.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39751, 'Email sent to: sportsstreamtt@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39752, 'Newsletter Sent [To : sportsstreamtt@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39753, 'Email sent to: jennellemorris@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39754, 'Newsletter Sent [To : jennellemorris@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39755, 'Email sent to: officialsonofking@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39756, 'Newsletter Sent [To : officialsonofking@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39757, 'Email sent to: jeremiahrleslie7@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39758, 'Newsletter Sent [To : jeremiahrleslie7@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39759, 'Email sent to: monifacrithlow17@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39760, 'Newsletter Sent [To : monifacrithlow17@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39761, 'Email sent to: latoyaj879@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39762, 'Newsletter Sent [To : latoyaj879@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39763, 'Email sent to: ettiennejoel4@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39764, 'Newsletter Sent [To : ettiennejoel4@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39765, 'Email sent to: zigboiinc@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39766, 'Newsletter Sent [To : zigboiinc@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39767, 'Email sent to: yuriful@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39768, 'Newsletter Sent [To : yuriful@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39769, 'Email sent to: anisiaspring@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39770, 'Newsletter Sent [To : anisiaspring@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39771, 'Email sent to: henryallison83@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39772, 'Newsletter Sent [To : henryallison83@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39773, 'Email sent to: ismachiah23@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39774, 'Newsletter Sent [To : ismachiah23@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39775, 'Email sent to: nayika_walia@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39776, 'Newsletter Sent [To : nayika_walia@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39777, 'Email sent to: nishahope502@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39778, 'Newsletter Sent [To : nishahope502@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39779, 'Email sent to: pernelapy@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39780, 'Newsletter Sent [To : pernelapy@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39781, 'Email sent to: melissahosein8@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39782, 'Newsletter Sent [To : melissahosein8@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39783, 'Email sent to: dianpersad@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39784, 'Newsletter Sent [To : dianpersad@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39785, 'Email sent to: prosolardirect@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39786, 'Newsletter Sent [To : prosolardirect@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39787, 'Email sent to: natalie.rocke@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39788, 'Newsletter Sent [To : natalie.rocke@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39789, 'Email sent to: bevbaycaribbean@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39790, 'Newsletter Sent [To : bevbaycaribbean@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39791, 'Email sent to: livinglovelly@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39792, 'Newsletter Sent [To : livinglovelly@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39793, 'Email sent to: isaiahsobers79@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39794, 'Newsletter Sent [To : isaiahsobers79@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39795, 'Email sent to: treue_engel@icloud.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39796, 'Newsletter Sent [To : treue_engel@icloud.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39797, 'Email sent to: ewilsonmaynard@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39798, 'Newsletter Sent [To : ewilsonmaynard@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39799, 'Email sent to: jyanenergyinvest@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39800, 'Newsletter Sent [To : jyanenergyinvest@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39801, 'Email sent to: karleem.g@saylesstt.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39802, 'Newsletter Sent [To : karleem.g@saylesstt.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39803, 'Email sent to: Junior_g7@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39804, 'Newsletter Sent [To : Junior_g7@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39805, 'Email sent to: empress1rachel@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39806, 'Newsletter Sent [To : empress1rachel@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39807, 'Email sent to: da_vo45@hotmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39808, 'Newsletter Sent [To : da_vo45@hotmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39809, 'Email sent to: stylesthatstandout@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39810, 'Newsletter Sent [To : stylesthatstandout@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39811, 'Email sent to: aktthomas69@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39812, 'Newsletter Sent [To : aktthomas69@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39813, 'Email sent to: Kerendarkiesimon@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39814, 'Newsletter Sent [To : Kerendarkiesimon@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39815, 'Email sent to: bencc@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39816, 'Newsletter Sent [To : bencc@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39817, 'Email sent to: sha27griffith@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39818, 'Newsletter Sent [To : sha27griffith@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39819, 'Email sent to: etherealdesignstt@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39820, 'Newsletter Sent [To : etherealdesignstt@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39821, 'Email sent to: horatioservice608@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39822, 'Newsletter Sent [To : horatioservice608@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39823, 'Email sent to: rennison166@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39824, 'Newsletter Sent [To : rennison166@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39825, 'Email sent to: cliffordstiling@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39826, 'Newsletter Sent [To : cliffordstiling@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39827, 'Email sent to: nichellemoore@live.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39828, 'Newsletter Sent [To : nichellemoore@live.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39829, 'Email sent to: castellanocontractors@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39830, 'Newsletter Sent [To : castellanocontractors@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39831, 'Email sent to: paulamarie1994@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39832, 'Newsletter Sent [To : paulamarie1994@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39833, 'Email sent to: lasanphil2@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39834, 'Newsletter Sent [To : lasanphil2@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39835, 'Email sent to: edwinwillet020@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39836, 'Newsletter Sent [To : edwinwillet020@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39837, 'Email sent to: tobagosavours@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39838, 'Newsletter Sent [To : tobagosavours@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39839, 'Email sent to: ttyellows@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39840, 'Newsletter Sent [To : ttyellows@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39841, 'Email sent to: kern.baptiste1980@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39842, 'Newsletter Sent [To : kern.baptiste1980@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39843, 'Email sent to: devydd@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39844, 'Newsletter Sent [To : devydd@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39845, 'Email sent to: platinumgroomingco.ltd@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39846, 'Newsletter Sent [To : platinumgroomingco.ltd@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39847, 'Email sent to: ceciliesaney@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39848, 'Newsletter Sent [To : ceciliesaney@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39849, 'Email sent to: wynett1@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39850, 'Newsletter Sent [To : wynett1@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39851, 'Email sent to: thomasatasha@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39852, 'Newsletter Sent [To : thomasatasha@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39853, 'Email sent to: simfa_51@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39854, 'Newsletter Sent [To : simfa_51@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39855, 'Email sent to: Terry.rose@outlook.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39856, 'Newsletter Sent [To : Terry.rose@outlook.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39857, 'Email sent to: dastaparris@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39858, 'Newsletter Sent [To : dastaparris@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39859, 'Email sent to: endajoseph33@outlook.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39860, 'Newsletter Sent [To : endajoseph33@outlook.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39861, 'Email sent to: o.ramjit@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39862, 'Newsletter Sent [To : o.ramjit@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39863, 'Email sent to: seansuper370@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39864, 'Newsletter Sent [To : seansuper370@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39865, 'Email sent to: coko_leche@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39866, 'Newsletter Sent [To : coko_leche@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39867, 'Email sent to: vcrichardsy@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39868, 'Newsletter Sent [To : vcrichardsy@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39869, 'Email sent to: iannahamlet@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39870, 'Newsletter Sent [To : iannahamlet@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39871, 'Email sent to: keresealleyne22@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39872, 'Newsletter Sent [To : keresealleyne22@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39873, 'Email sent to: nobadistributionbv@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39874, 'Newsletter Sent [To : nobadistributionbv@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39875, 'Email sent to: twilighteventstt@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39876, 'Newsletter Sent [To : twilighteventstt@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39877, 'Email sent to: marissasylvester8@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39878, 'Newsletter Sent [To : marissasylvester8@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39879, 'Email sent to: ashtonboochun@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39880, 'Newsletter Sent [To : ashtonboochun@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39881, 'Email sent to: marquisgillard33@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39882, 'Newsletter Sent [To : marquisgillard33@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39883, 'Email sent to: annumsaeed2021@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39884, 'Newsletter Sent [To : annumsaeed2021@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39885, 'Email sent to: nyolaevents@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39886, 'Newsletter Sent [To : nyolaevents@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39887, 'Email sent to: shane_delas@live.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39888, 'Newsletter Sent [To : shane_delas@live.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39889, 'Email sent to: jttplumbingservices@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39890, 'Newsletter Sent [To : jttplumbingservices@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39891, 'Email sent to: crystal.dragon28@yahoo.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39892, 'Newsletter Sent [To : crystal.dragon28@yahoo.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39893, 'Email sent to: maurisamahase@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39894, 'Newsletter Sent [To : maurisamahase@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39895, 'Email sent to: richardqmlewis@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39896, 'Newsletter Sent [To : richardqmlewis@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39897, 'Email sent to: saylesstt@gmail.com Subject: Build Your Own Website For Less', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39898, 'Newsletter Sent [To : saylesstt@gmail.com]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39899, 'Newsletter Sent [Newsletter Subject - Build Your Own Website For Less - Total Emails: 140 - Total Emails Sent: 140 - Total Failed Emails: 0]', '2024-07-19 18:14:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39984, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Overdue Notice]', '2024-07-19 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (39999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-19 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-19 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-19 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40078, 'Database Backup [database_backup_2024-07-20-00-00-04-v3-1-1.zip]', '2024-07-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40349, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 207.195.86.22]', '2024-07-20 08:44:18', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 12:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40518, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.182]', '2024-07-20 14:10:31', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40525, 'Invoice Status Updated [Invoice Number: INV-134/05/2024, From: Partially Paid To: Paid]', '2024-07-20 14:25:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40526, 'Payment Recorded [ID:104, Invoice Number: INV-134/05/2024, Total: $2,000.00]', '2024-07-20 14:25:34', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40527, 'Email Sent To [Email: drelectronicstt@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-20 14:25:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40591, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.182]', '2024-07-20 16:26:02', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40616, 'Non Existing User Tried to Login [Email: brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 181.118.39.171]', '2024-07-20 17:14:19', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40617, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 181.118.39.171]', '2024-07-20 17:15:33', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40621, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 181.118.39.171]', '2024-07-20 17:17:29', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40622, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 17:20:53', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40626, 'Non Existing User Tried to Login [Email: brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 17:22:14', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40627, 'Non Existing User Tried to Login [Email: brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 17:23:13', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40649, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 18:03:30', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40650, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 18:04:27', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40651, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 18:06:03', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40658, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 181.118.39.171]', '2024-07-20 18:15:34', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40659, 'Non Existing User Tried to Login [Email: Brinsley.smith@lobaxtt.com, Is Staff Member: Yes, IP: 201.238.127.69]', '2024-07-20 18:19:35', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40741, 'Email Sent To [Email: shinshin.s369@gmail.com, Template: Invoice Overdue Notice]', '2024-07-20 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40742, 'Email Sent To [Email: shinshin.s369@gmail.com, Template: Invoice Overdue Notice]', '2024-07-20 21:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40743, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-20 21:00:28', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40744, 'Email Sent To [Email: brinsley.smith@lobaxtt.com, Template: Invoice Overdue Notice]', '2024-07-20 21:00:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40745, 'Email Sent To [Email: omarimoore19@hotmail.com, Template: Invoice Overdue Notice]', '2024-07-20 21:00:45', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40746, 'Invoice Status Updated [Invoice Number: INV-128/07/2024, From: Unpaid To: Overdue]', '2024-07-20 21:00:45', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:00:45', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:00:45', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:00:45', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-20 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-20 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-20 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40843, 'Database Backup [database_backup_2024-07-21-00-02-02-v3-1-1.zip]', '2024-07-21 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (40999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41003, 'Failed Login Attempt [Email: brinsley.smith@lobaxtt.com, Is Staff Member: No, IP: 186.44.181.251]', '2024-07-21 05:21:35', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41007, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 186.44.181.251]', '2024-07-21 05:22:40', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41476, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-21 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41477, 'Email Sent To [Email: nobadistributionbv@gmail.com, Template: Invoice Overdue Notice]', '2024-07-21 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41478, 'Invoice Status Updated [Invoice Number: INV-149/07/2024, From: Unpaid To: Overdue]', '2024-07-21 21:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41479, 'Email Sent To [Email: lessons1on1@gmail.com, Template: Invoice Due Notice]', '2024-07-21 21:00:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:00:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:00:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:00:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41498, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-21 21:33:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41499, 'Invoice Status Updated [Invoice Number: INV-147/06/2024, From: Overdue To: Unpaid]', '2024-07-21 21:34:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41503, 'Invoice Status Updated [Invoice Number: INV-145/06/2024, From: Overdue To: Unpaid]', '2024-07-21 21:38:24', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41507, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-21 21:45:56', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41511, 'Invoice Status Updated [Invoice Number: INV-115/03/2024, From: Partially Paid To: Paid]', '2024-07-21 21:51:05', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41515, 'Invoice Status Updated [Invoice Number: INV-128/07/2024, From: Overdue To: Unpaid]', '2024-07-21 21:54:55', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41516, 'Invoice Status Updated [Invoice Number: INV-142/06/2024, From: Overdue To: Unpaid]', '2024-07-21 21:58:07', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41517, 'Invoice Status Updated [Invoice Number: INV-143/06/2024, From: Overdue To: Unpaid]', '2024-07-21 21:58:44', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41518, 'Invoice Status Updated [Invoice Number: INV-144/06/2024, From: Overdue To: Unpaid]', '2024-07-21 21:58:48', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41519, 'Invoice Status Updated [Invoice Number: INV-146/06/2024, From: Overdue To: Unpaid]', '2024-07-21 21:59:21', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41520, 'Invoice Status Updated [Invoice Number: INV-153/07/2024, From: Overdue To: Unpaid]', '2024-07-21 21:59:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41524, 'Invoice Status Updated [Invoice Number: INV-149/07/2024, From: Overdue To: Unpaid]', '2024-07-21 22:00:16', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41525, 'Invoice Status Updated [Invoice Number: INV-148/06/2024, From: Overdue To: Unpaid]', '2024-07-21 22:00:27', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41526, 'Invoice Status Updated [Invoice Number: INV-150/07/2024, From: Overdue To: Unpaid]', '2024-07-21 22:00:55', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41527, 'Invoice Status Updated [Invoice Number: INV-151/07/2024, From: Overdue To: Unpaid]', '2024-07-21 22:01:00', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-21 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41588, 'Database Backup [database_backup_2024-07-22-00-00-04-v3-1-1.zip]', '2024-07-22 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 00:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 00:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 00:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (41999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42009, 'User Successfully Logged In [User Id: 83, Is Staff Member: No, IP: 161.0.156.111]', '2024-07-22 13:57:01', 'Brinsley Smith');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42082, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-22 16:19:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 16:54:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 16:54:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 16:54:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42104, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-22 17:02:31', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:42:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:42:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:42:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:05:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:05:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:05:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:06:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-22 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-22 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-22 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42321, 'Database Backup [database_backup_2024-07-23-00-00-03-v3-1-1.zip]', '2024-07-23 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:16:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:14:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:14:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:14:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:26:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42535, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 207.195.86.22]', '2024-07-23 07:04:46', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42683, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-23 11:55:18', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42690, 'Failed Login Attempt [Email: livinglovelly@gmail.com, Is Staff Member: No, IP: 181.118.42.96]', '2024-07-23 12:10:15', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42958, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Task Deadline Reminder - Sent to Assigned Members]', '2024-07-23 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42959, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (42999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-23 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43053, 'Database Backup [database_backup_2024-07-24-00-00-05-v3-1-1.zip]', '2024-07-24 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:00:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43450, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 200.7.90.158]', '2024-07-24 13:07:36', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43457, 'User Successfully Logged In [User Id: 2, Is Staff Member: No, IP: 2604:3d09:e072:b700:f8a0:825:6a3d:9de5]', '2024-07-24 13:18:37', 'Al Jones ');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43467, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.134]', '2024-07-24 13:32:11', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43471, 'New Payment Mode Added [ID: 4, Name:Manual Paypal Payment]', '2024-07-24 13:41:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43472, 'Payment Recorded [ID:105, Invoice Number: INV-133/05/2024, Total: $2,800.00]', '2024-07-24 13:44:01', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43476, 'Email Sent To [Email: livinglovelly@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-07-24 13:44:09', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43477, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-07-24 13:44:12', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43610, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.24]', '2024-07-24 18:09:23', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-07-24 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-07-24 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (43627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-07-24 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staf