#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=175909 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (151999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-09 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-09 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-09 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152122, 'Database Backup [database_backup_2024-12-10-00-00-05-v3-1-6.zip]', '2024-12-10 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152819, 'Invoice Status Updated [Invoice Number: INV-167/12/2024, From: Unpaid To: Overdue]', '2024-12-10 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152820, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2024-12-10 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-10 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-10 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-10 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152923, 'Database Backup [database_backup_2024-12-11-00-02-02-v3-1-6.zip]', '2024-12-11 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (152999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153050, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.145]', '2024-12-11 03:51:06', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153054, 'Invoice Deleted [INV-167/12/2024]', '2024-12-11 03:53:22', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153055, 'Invoice Status Updated [Invoice Number: INV-159/07/2024, From: Partially Paid To: Paid]', '2024-12-11 03:55:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153056, 'Payment Recorded [ID:122, Invoice Number: INV-159/07/2024, Total: $750.00]', '2024-12-11 03:55:04', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153057, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2024-12-11 03:55:09', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153058, 'Email Sent To [Email: tishara.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2024-12-11 03:55:12', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153617, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-11 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-11 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-11 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-11 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153717, 'Database Backup [database_backup_2024-12-12-00-00-05-v3-1-6.zip]', '2024-12-12 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (153999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 09:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 15:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 16:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154519, 'Database Backup [database_backup_2024-12-13-00-00-02-v3-1-6.zip]', '2024-12-13 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-12-13 12:54:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-12-13 13:05:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-12-13 13:11:57', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-12-13 13:17:32', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-12-13 13:29:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-12-13 13:35:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (154999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-13 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-13 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-13 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155318, 'Database Backup [database_backup_2024-12-14-00-02-02-v3-1-6.zip]', '2024-12-14 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-14 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-14 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (155892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-14 