#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=144194 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:11:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (119999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 14:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 17:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120282, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-10-30 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120283, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-30 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120386, 'Database Backup [database_backup_2024-10-31-00-04-02-v3-1-6.zip]', '2024-10-31 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 01:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (120999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-10-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-10-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-10-31 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121176, 'Database Backup [database_backup_2024-11-01-00-04-01-v3-1-6.zip]', '2024-11-01 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 17:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-01 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-01 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-01 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121975, 'Database Backup [database_backup_2024-11-02-00-04-03-v3-1-6.zip]', '2024-11-02 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (121999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 08:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 08:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 08:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122663, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-02 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122664, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-02 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-02 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122767, 'Database Backup [database_backup_2024-11-03-00-03-02-v3-1-6.zip]', '2024-11-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (122999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 10:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 11:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-03 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-03 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-03 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123554, 'Database Backup [database_backup_2024-11-04-00-04-02-v3-1-6.zip]', '2024-11-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 02:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 04:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 06:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (123999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-04 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-04 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (124165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-04 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` 