#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=218389 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 09:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 10:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196589, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-03 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196590, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-03 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-03 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-03 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-03 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196690, 'Database Backup [database_backup_2025-02-04-00-02-02-v3-1-6.zip]', '2025-02-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (196999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197375, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-04 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-04 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197478, 'Database Backup [database_backup_2025-02-05-00-01-13-v3-1-6.zip]', '2025-02-05 00:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197479, 'Database Backup [database_backup_2025-02-05-00-01-13-v3-1-6-1.zip]', '2025-02-05 00:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 04:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 06:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197852, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.175]', '2025-02-05 11:12:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (197999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-05 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198279, 'Database Backup [database_backup_2025-02-06-00-00-03-v3-1-6.zip]', '2025-02-06 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198970, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-06 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198971, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-02-06 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (198999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-06 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199071, 'Database Backup [database_backup_2025-02-07-00-02-06-v3-1-6.zip]', '2025-02-07 00:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199765, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-02-07 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-07 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199871, 'Database Backup [database_backup_2025-02-08-00-04-02-v3-1-6.zip]', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199872, 'Database Backup [database_backup_2025-02-08-00-04-02-v3-1-6-1.zip]', '2025-02-08 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (199999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:18:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:18:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:18:37', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-02-08 17:19:46', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:23:41', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:23:41', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:23:41', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 17:57:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 17:57:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 17:57:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-02-08 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-02-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-02-08 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (200470, 'Failed to connect to IMAP auto importing tic