#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=328594 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:09:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:10:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302574, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:19:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:41:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:30:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:58:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302986, 'Database Backup [database_backup_2025-06-15-00-02-06-v3-1-6.zip]', '2025-06-15 00:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:37:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:43:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:23:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 13:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 13:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 13:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 13:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 14:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 15:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 15:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 16:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 17:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 17:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 17:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 17:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 18:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 19:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 19:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:23:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:41:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 20:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:04:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:04:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:04:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:04:29', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:09:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 21:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 21:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 21:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 21:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 22:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 22:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 22:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 22:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:16:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 23:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303983, 'Database Backup [database_backup_2025-06-16-00-03-05-v3-1-6.zip]', '2025-06-16 00:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303988, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 00:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 00:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:53:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 01:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 02:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 03:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 03:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 04:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 04:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 04:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 04:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 05:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 05:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 05:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 05:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:06:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 06:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 07:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 07:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 07:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 07:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:23:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 08:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 08:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 08:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 08:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:29:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 09:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 09:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 09:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 09:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 10:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 10:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:21:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:33:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:39:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:44:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 11:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 11:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 11:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 11:56:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:07:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:13:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:19:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:24:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:30:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:36:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:41:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:46:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:52:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:52:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 12:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 12:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 12:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 12:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:16:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:16:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:16:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 13:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 13:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 13:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 13:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304593, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:33:37', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304594, 'Non Existing User Tried to Login [Email: admin@saylessdigital.io, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:33:47', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304595, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:34:08', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304596, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:34:30', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304597, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:34:54', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304598, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:35:33', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304599, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 190.83.148.247]', '2025-06-16 14:35:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:44:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 14:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:38:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:49:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:49:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 15:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 15:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 15:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 15:55:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:23:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:35:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:46:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:46:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 16:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 16:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 16:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 16:57:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:31:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 17:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 17:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 17:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 17:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:27:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:33:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:44:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 18:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 18:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 19:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 20:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 20:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 20:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 20:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 21:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 21:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 21:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 21:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:00:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 22:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 22:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 22:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 22:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-16 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-16 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-16 23:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-16 23:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304991, 'Database Backup [database_backup_2025-06-17-00-00-07-v3-1-6.zip]', '2025-06-17 00:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304992, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304996, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (304999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:36:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 00:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:05:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 01:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 02:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 03:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 03:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 03:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 03:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 04:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 04:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 04:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 04:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 05:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 05:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 06:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 06:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 06:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 06:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305301, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:e55b:6982:e5ed:f910]', '2025-06-17 07:28:45', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305302, 'Invoice Status Updated [Invoice Number: INV-173/05/2025, From: Overdue To: Paid]', '2025-06-17 07:29:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305303, 'Payment Recorded [ID:128, Invoice Number: INV-173/05/2025, Total: $500.00]', '2025-06-17 07:29:53', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:44:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:44:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:50:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 07:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 08:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 08:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 08:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 08:57:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:32:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:37:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:37:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:43:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:49:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 09:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 09:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 09:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 09:55:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:06:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:30:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 10:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 10:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 10:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 10:54:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:28:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:39:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:44:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:50:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 11:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 11:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 11:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 11:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:24:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305511, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:24:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305515, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:29:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305519, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305523, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305527, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305531, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 12:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 12:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 12:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305535, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 12:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305539, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305543, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:08:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305547, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305551, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305555, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305559, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:30:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305563, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:42:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305567, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:42:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305571, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305575, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 13:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305579, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305583, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305587, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305591, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305595, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305599, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305603, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305607, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:42:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:48:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305611, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:48:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 14:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305615, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 14:54:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305619, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305623, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:10:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305627, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305631, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305635, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305639, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305643, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305647, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305651, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305655, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 15:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 15:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305659, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 15:56:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305663, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305667, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305671, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305675, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305679, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305683, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305687, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305691, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305695, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305699, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 16:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305703, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305707, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305711, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305715, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:17:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305719, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:22:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305723, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:28:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305727, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305731, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:40:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305735, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305739, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 17:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305743, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 17:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305747, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305751, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305755, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:14:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305759, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305763, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305767, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305771, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:42:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305775, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:42:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305779, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 18:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 18:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 18:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305783, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 18:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305787, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305791, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305795, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305799, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:18:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305803, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:23:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305807, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305811, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:40:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305815, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305819, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:46:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305823, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 19:58:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305827, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 19:58:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305831, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305835, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305839, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305843, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305847, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305851, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:31:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305855, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305859, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305863, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:48:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305867, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 20:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 20:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 20:59:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305871, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 20:59:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305875, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305879, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305883, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305887, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305891, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305895, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:39:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305899, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:39:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305903, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305907, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 21:55:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 21:55:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 21:55:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305911, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 21:55:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305915, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:01:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305919, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305923, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305927, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305931, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305935, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305939, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305943, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305947, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305951, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 22:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305955, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 22:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305959, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305963, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:10:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305967, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305971, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305975, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:27:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305979, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305983, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:49:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-17 23:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-17 23:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-17 23:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-17 23:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (305999, 'Database Backup [database_backup_2025-06-18-00-00-16-v3-1-6.zip]', '2025-06-18 00:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306000, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:00:21', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306004, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306008, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306012, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:17:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306016, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306020, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306024, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306028, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306032, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:51:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306036, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:51:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 00:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306040, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 00:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306044, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306048, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306052, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:13:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306056, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306060, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306064, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306068, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306072, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306076, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306080, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 01:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306084, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306088, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306092, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306096, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306100, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306104, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306108, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306112, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306116, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306120, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 02:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 02:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 02:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306124, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 02:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306128, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306132, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306136, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306140, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306144, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306148, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306152, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306156, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306160, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306164, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 03:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306168, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306172, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:10:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306176, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306180, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306184, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306188, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306192, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306196, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306200, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 04:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 04:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 04:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306204, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 04:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306208, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306212, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306216, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306220, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306224, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306228, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306232, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306236, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306240, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306244, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 05:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306248, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306252, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306256, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306260, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306264, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306268, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306272, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306276, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306280, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306284, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 06:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306288, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 06:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306292, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306296, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306300, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306304, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306308, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306312, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306316, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306320, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:44:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306324, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 07:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306328, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 07:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306332, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306336, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:07:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306340, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306344, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306348, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306352, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306356, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306360, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:41:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306364, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306368, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 08:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 08:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 08:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306372, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 08:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306376, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306380, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306384, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306388, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:21:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306392, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306396, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:33:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306400, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306404, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306408, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 09:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 09:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 09:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306412, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 09:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306416, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306420, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306424, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306428, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306432, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306436, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:35:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306440, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:35:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306444, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306448, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306452, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 10:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306456, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 10:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306460, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:03:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306464, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:09:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306468, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:21:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306472, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:21:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306476, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306480, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306484, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306492, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306496, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 11:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306500, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:08:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306504, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:08:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306508, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306512, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306516, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306520, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306524, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306528, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306532, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306536, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 12:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 12:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 12:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306540, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 12:59:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306544, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:11:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306548, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306552, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306556, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306560, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306564, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306568, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306572, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:44:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306576, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:50:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 13:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306580, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 13:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:36:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306616, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:52:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306620, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:52:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306624, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 14:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306628, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306632, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306636, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:20:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306640, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:20:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306644, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:25:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306648, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:31:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:37:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:37:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306652, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:37:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306656, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:43:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306660, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 15:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306664, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 15:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306668, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306672, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306676, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:12:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306680, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306684, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306688, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306692, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306696, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306700, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 16:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306704, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 16:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306708, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306712, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:11:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306716, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:17:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306720, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306724, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306728, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-18 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306732, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-18 17:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-18 17:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-18 17:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (306735,