#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=380672 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (367999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368328, 'Invoice Status Updated [Invoice Number: INV-192/09/2025, From: Unpaid To: Overdue]', '2025-09-17 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368329, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Overdue Notice]', '2025-09-17 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368330, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Overdue Notice]', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-17 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368427, 'Database Backup [database_backup_2025-09-18-00-03-02-v3-3-1.zip]', '2025-09-18 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368758, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:79e8:1ee5:3722:2c55]', '2025-09-18 10:42:47', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368759, 'Non Existing User Tried to Login [Email: tishara.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:8798:79e8:1ee5:3722:2c55]', '2025-09-18 10:42:59', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368760, 'Invoice Status Updated [Invoice Number: INV-179/07/2025, From: Overdue To: Partially Paid]', '2025-09-18 10:45:37', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368761, 'Payment Recorded [ID:140, Invoice Number: INV-179/07/2025, Total: $500.00]', '2025-09-18 10:45:37', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368762, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-09-18 10:45:40', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 12:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (368999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369084, 'Invoice Status Updated [Invoice Number: INV-190/09/2025, From: Unpaid To: Overdue]', '2025-09-18 21:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369085, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369086, 'Invoice Status Updated [Invoice Number: INV-191/09/2025, From: Unpaid To: Overdue]', '2025-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369087, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-18 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369184, 'Database Backup [database_backup_2025-09-19-00-00-03-v3-3-1.zip]', '2025-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-19 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-19 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-19 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369290, 'Database Backup [database_backup_2025-09-22-06-40-05-v3-3-1.zip]', '2025-09-22 06:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369729, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369730, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369731, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-22 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369732, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369733, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369734, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369735, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-22 21:03:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369736, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369737, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Overdue Notice]', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-22 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (369999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-23 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370581, 'Database Backup [database_backup_2025-09-24-00-04-02-v3-3-1.zip]', '2025-09-24 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (370999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 21:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-24 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-24 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-24 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371326, 'Database Backup [database_backup_2025-09-25-00-04-04-v3-3-1.zip]', '2025-09-25 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 02:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 07:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 12:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371975, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371976, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371977, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-25 21:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371978, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371979, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371980, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371981, 'Email Sent To [Email: tishara.f@saylessdigital.io, Template: Invoice Overdue Notice]', '2025-09-25 21:03:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371982, 'Email Sent To [Email: sealylewis@hotmail.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:31', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371983, 'Email Sent To [Email: support@saylesstt.com, Template: Invoice Overdue Notice]', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:03:33', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (371999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-25 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-25 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-25 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372080, 'Database Backup [database_backup_2025-09-26-00-03-02-v3-3-1.zip]', '2025-09-26 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 03:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 03:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-26 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-26 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-26 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372177, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:10:40', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372178, 'Failed Login Attempt [Email: tishara.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:10:52', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372179, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:11:07', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372180, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:8798:9803:7b02:489f:ae38]', '2025-09-26 05:11:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372184, 'Database Backup [database_backup_2025-09-29-06-52-03-v3-3-1.zip]', '2025-09-29 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-09-29 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-09-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-09-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (372241, 'Failed to connect to IMAP auto importing tickets for department 