#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=265928 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241210, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241322, 'Database Backup [database_backup_2025-03-31-00-03-02-v3-1-6.zip]', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242028, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Due Notice]', '2025-03-31 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242029, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Due Notice]', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242129, 'Database Backup [database_backup_2025-04-01-00-02-04-v3-1-6.zip]', '2025-04-01 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242832, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-01 21:01:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242833, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-04-01 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:01:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242936, 'Database Backup [database_backup_2025-04-02-00-04-02-v3-1-6.zip]', '2025-04-02 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243681, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-02 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243793, 'Database Backup [database_backup_2025-04-03-00-03-03-v3-1-6.zip]', '2025-04-03 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (243999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 06:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 09:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 12:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 19:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244514, 'Invoice Status Updated [Invoice Number: INV-171/03/2025, From: Unpaid To: Overdue]', '2025-04-03 21:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244515, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Overdue Notice]', '2025-04-03 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244516, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Overdue Notice]', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-03 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-03 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-03 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244622, 'Database Backup [database_backup_2025-04-04-00-02-05-v3-1-6.zip]', '2025-04-04 00:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 01:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (244999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 13:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-04 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-04 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-04 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (245097, 'Failed to conne