#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=354933 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341745, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:3c63:8194:712:8e9a]', '2025-07-31 11:53:41', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341749, 'Invoice Status Updated [Invoice Number: INV-174/06/2025, From: Overdue To: Paid]', '2025-07-31 11:56:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341750, 'Payment Recorded [ID:129, Invoice Number: INV-174/06/2025, Total: $1,000.00]', '2025-07-31 11:56:42', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341751, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-07-31 11:56:45', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341752, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-07-31 11:56:48', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341753, 'Copied Invoice INV-174/06/2025', '2025-07-31 11:57:47', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341754, 'Invoice Status Updated [Invoice Number: INV-180/07/2025, From: Draft To: Paid]', '2025-07-31 11:58:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341755, 'Payment Recorded [ID:130, Invoice Number: INV-180/07/2025, Total: $1,000.00]', '2025-07-31 11:58:46', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341756, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Payment Recorded (Sent to Customer)]', '2025-07-31 11:58:49', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341757, 'Email Sent To [Email: dallas.f@saylesstt.com, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-07-31 11:58:51', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 12:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 13:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (341999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342034, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-31 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342035, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Due Notice]', '2025-07-31 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342036, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Due Notice]', '2025-07-31 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-31 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-31 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-31 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342133, 'Database Backup [database_backup_2025-08-01-00-03-09-v3-3-1.zip]', '2025-08-01 00:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342479, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:95cc:570f:e0ca:5032:d4c5]', '2025-08-01 11:13:17', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342480, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:95cc:570f:e0ca:5032:d4c5]', '2025-08-01 11:13:28', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342481, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:95cc:570f:e0ca:5032:d4c5]', '2025-08-01 11:14:07', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342482, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:95cc:570f:e0ca:5032:d4c5]', '2025-08-01 11:14:23', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342489, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:26:03', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342490, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:26:08', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342491, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:26:36', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342492, 'Non Existing User Tried to Login [Email: tishara.f@successlaunchkit.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:26:52', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342493, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:3c63:8194:712:8e9a]', '2025-08-01 11:27:35', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342497, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:30:49', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342501, 'Staff Member Updated [ID: 2, Dallas Ferdinand]', '2025-08-01 11:37:48', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342502, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:38:01', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342503, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:38:12', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342504, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:38:41', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342505, 'Staff Member Updated [ID: 2, Dallas Ferdinand]', '2025-08-01 11:39:15', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342506, 'Non Existing User Tried to Login [Email: dallas.f@saylesstt.com, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:39:21', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342507, 'Non Existing User Tried to Login [Email: dallas.f@saylessdigital.io, Is Staff Member: No, IP: 2803:1500:1c00:a4e7:627b:b3bc:7735:850d]', '2025-08-01 11:39:38', NULL);
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 20:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342796, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-08-01 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-01 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342893, 'Database Backup [database_backup_2025-08-02-00-00-03-v3-3-1.zip]', '2025-08-02 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (342999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 05:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 18:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343539, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-02 21:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343540, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-02 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343541, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-02 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 21:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-02 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-02 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-02 23:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343635, 'Database Backup [database_backup_2025-08-03-00-02-02-v3-3-1.zip]', '2025-08-03 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 08:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (343999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344284, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-03 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344285, 'Invoice Status Updated [Invoice Number: INV-179/07/2025, From: Unpaid To: Overdue]', '2025-08-03 21:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344286, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-08-03 21:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344287, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-08-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-03 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344384, 'Database Backup [database_backup_2025-08-04-00-04-02-v3-3-1.zip]', '2025-08-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 03:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 05:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 07:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 09:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 15:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (344999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345042, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Overdue Notice]', '2025-08-04 21:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-04 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345136, 'Database Backup [database_backup_2025-08-05-00-01-02-v3-3-1.zip]', '2025-08-05 00:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 00:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345446, 'User Successfully Logged In [User Id: 3, Is Staff Member: Yes, IP: 2803:1500:1c00:a4e7:24fa:7041:debf:72f5]', '2025-08-05 09:59:38', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345468, 'Invoice Status Updated [Invoice Number: INV-176/06/2025, From: Overdue To: Paid]', '2025-08-05 10:36:08', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345469, 'Payment Recorded [ID:131, Invoice Number: INV-176/06/2025, Total: $500.00]', '2025-08-05 10:36:08', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345470, 'Email Sent To [Email: dallas.f@saylessdigital.io, Template: Invoice Payment Recorded (Sent to Staff)]', '2025-08-05 10:36:10', 'Tishara Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 10:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345792, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-08-05 21:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345793, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-08-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-05 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-05 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-05 23:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345890, 'Database Backup [database_backup_2025-08-06-00-04-03-v3-3-1.zip]', '2025-08-06 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-08-06 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-08-06 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-08-06 01:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (345941, 'Failed to con